<?php
// URL سایت هدف
$url = 'https://taw-bio.ir/tag/Bio/انگیزشی';

// استفاده از cURL برای گرفتن محتوا از سایت
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
$html = curl_exec($ch);
curl_close($ch);

// استفاده از DOMDocument برای تجزیه و تحلیل HTML
libxml_use_internal_errors(true);
$dom = new DOMDocument();
$dom->loadHTML($html);
$xpath = new DOMXPath($dom);

// استخراج تمامی متن‌ها از div با کلاس "t fa"
$nodes = $xpath->query('//div[@class="t fa"]');
$texts = [];

// استخراج متون از گره‌ها
foreach ($nodes as $node) {
    $texts[] = $node->nodeValue;
}

// انتخاب یک متن به صورت تصادفی
$randomText = $texts[array_rand($texts)];

// بازگشت متن به صورت JSON
header('Content-Type: application/json');
echo json_encode(['text' => $randomText]);

?>
