import packages_local.rubpy
import time
import asyncio
import pathlib
import os , sys
from pathlib import Path
try:
    from aiortc import RTCPeerConnection, RTCSessionDescription, MediaStreamTrack
    from aiortc.contrib.media import MediaPlayer

except ImportError:
    print('> Installing aiortc ...')
    os.system(f'{sys.executable} -m pip install -U aiortc ')
    print('> Done.')
    from aiortc import RTCPeerConnection, RTCSessionDescription, MediaStreamTrack
    from aiortc.contrib.media import MediaPlayer
try:
    import aiortc
    from aiortc.contrib.media import MediaPlayer
except ImportError:
    aiortc = None
try:
    import numpy as np
except ImportError:
    print('> Installing numpy...')
    os.system(f'{sys.executable} -m pip install -U numpy')
    print('> Done.')
    import numpy as np


class VoiceChatPlayer:
    async def heartbeat(self: "packages_local.rubpy.Client", chat_guid: str, voice_chat_id: str) -> None:
        while True:
            try:
                await self.get_group_voice_chat_updates(chat_guid, voice_chat_id, int(time.time()))
                await asyncio.sleep(10)
            except (packages_local.rubpy.exceptions.InvalidAuth, packages_local.rubpy.exceptions.InvalidInput):
                break
            except Exception:
                continue

    async def speaking(self: "packages_local.rubpy.Client", chat_guid: str, voice_chat_id: str) -> None:
        while True:
            try:
                await self.send_group_voice_chat_activity(chat_guid, voice_chat_id)
                await asyncio.sleep(1)
            except (packages_local.rubpy.exceptions.InvalidAuth, packages_local.rubpy.exceptions.InvalidInput):
                break
            except Exception:
                continue

    class CustomAudioTrack(MediaStreamTrack):
        kind = "audio"

        def __init__(self, player, speed=1.0, volume=1.0):
            super().__init__()
            self.player = player.audio
            self._speed = speed
            self._volume = volume

        async def recv(self):
            frame = await self.player.recv()

            # سرعت
            if self._speed > 1.0:
                skip_count = int(self._speed) - 1
                for _ in range(skip_count):
                    try:
                        await self.player.recv()
                    except:
                        break

            # ولوم
            if self._volume != 1.0:
                samples = frame.to_ndarray()
                samples = np.clip(samples * self._volume, -32768, 32767).astype(np.int16)
                frame.planes[0].update(samples.tobytes())

            return frame

        def set_volume(self, new_volume: int):
            """ تغییر ولوم در حین پخش (۰ تا ۱۰۰) """
            self._volume = max(0, min(new_volume, 100)) / 78

        def set_speed(self, new_speed: float):
            """ تغییر سرعت در حین پخش (۰.۵x, ۱x, ۱.۵x, ۲x ...) """
            self._speed = max(0.5, min(new_speed, 3.0))  # محدودیت سرعت بین ۰.۵ تا ۳

    async def voice_chat_player(self, chat_guid: str, media, loop: bool = False, speed: float = 1.0, volume: int = 100) -> bool:
        if aiortc is None:
            self.logger.error("کتابخانه aiortc نصب نیست.")
            return False

        media = Path(media)
        if not media.exists() or not media.is_file():
            self.logger.error(f"فایل صوتی یافت نشد: {media}")
            return False

        # ✅ تبدیل درصد ولوم به مقدار واقعی
        volume = max(0, min(volume, 100)) / 78

        chat_info = await self.get_info(chat_guid)
        voice_chat_id = chat_info.chat.find_keys('{}_voice_chat_id'.format('group' if chat_guid.startswith('g0') else 'channel'))

        if voice_chat_id is None:
            voice_chat = (await self.create_group_voice_chat(chat_guid) if chat_guid.startswith('g0') else
                          await self.create_channel_voice_chat(chat_guid))
            voice_chat_id = voice_chat.find_keys('voice_chat_id')
            if voice_chat_id is None:
                voice_chat_id = (voice_chat.group_voice_chat_update.voice_chat_id if chat_guid.startswith('g0') else
                                 voice_chat.channel_voice_chat_update.voice_chat_id)

        self.logger.info(f'شروع پخش VoiceChat: chat_guid={chat_guid} | voice_chat_id={voice_chat_id}')

        pc = RTCPeerConnection()
        player = MediaPlayer(str(media), decode=True)
        self.current_track = self.CustomAudioTrack(player, speed=speed, volume=volume)
        pc.addTrack(self.current_track)

        try:
            offer = await pc.createOffer()
            await pc.setLocalDescription(offer)

            join = await self.join_voice_chat(chat_guid, voice_chat_id, offer.sdp)
            await self.set_voice_chat_state(chat_guid, voice_chat_id)
            asyncio.create_task(self.speaking(chat_guid, voice_chat_id))
            asyncio.create_task(self.heartbeat(chat_guid, voice_chat_id))

            await pc.setRemoteDescription(RTCSessionDescription(join.sdp_answer_data, 'answer'))

            @pc.on('iceconnectionstatechange')
            def on_ice():
                self.logger.info(f'ICE state: {pc.iceConnectionState}')

            @pc.on('connectionstatechange')
            def on_conn():
                self.logger.info(f'Connection state: {pc.connectionState}')

            while True:
                await asyncio.sleep(1)
                if pc.connectionState in ['failed', 'closed']:
                    break

        except Exception as e:
            self.logger.error(f'خطا در پخش صوت: {e}')
            return False

        finally:
            await pc.close()
            self.logger.info('Voice chat player پایان یافت.')

        return True

    async def velom(self, new_volume: int):
        """ تغییر ولوم حین پخش """
        if hasattr(self, "current_track") and self.current_track:
            self.current_track.set_volume(new_volume)
            self.logger.info(f"🔊 ولوم تغییر کرد: {new_volume}")
        else:
            self.logger.warning("⚠️ هنوز هیچ ترک فعالی برای تغییر ولوم وجود ندارد.")

    async def speed(self, new_speed: float):
        """ تغییر سرعت حین پخش """
        if hasattr(self, "current_track") and self.current_track:
            self.current_track.set_speed(new_speed)
            self.logger.info(f"⏩ سرعت تغییر کرد: {new_speed}x")
        else:
            self.logger.warning("⚠️ هنوز هیچ ترک فعالی برای تغییر سرعت وجود ندارد.")
