from rubpy.types import Updates
from rubpy import Client, filters
from asyncio import run
from datetime import datetime, timedelta
from bs4 import BeautifulSoup
import urllib.parse
import asyncio
import requests
import aiohttp
import jdatetime
import os
import time
import sys
import sqlite3
import random
nameser  =  'Musicalltest'
url = f"https://c-e-g.ir/اطلاعات/{nameser}"
response = requests.get(url).json()
# بررسی تعداد داده‌ها و استخراج اطلاعات
SESSIONS = []
for data in response[:2]:  # دریافت دو مورد اول در صورت وجود
    session = {
        "name": data["name"],
        "group_guid": data["group_guid"],
        "owner": data["owner"],
        "SERVER": data["SERVER"],
        "sharj": data["sharj"]
    }
    SESSIONS.append(session)
print(SESSIONS)
# [
#     {"name": "11-musicall", "group_guid": "g0Dd5OG024caac1187c1174983240782", "owner": "u0HXgNL079482b481860d16cb3abb2ec", "SERVER": "musicall-1-mon-19", "sharj": "1404-3-2"}
# ]
# اطلاعات نشست‌ها، گروه‌ها و مالکان

helps1 = '''
━━━━━━━┅┅ ✰ ┅┅━━━━━━━
𝟏 - سرچ〔اسم خواننده و تیکه ای از اهنگ〕
☯︎‍‌ - مثال » سرچ هـــایــــده گــل پـونـه
━━━━━━━┅┅ ☯︎‍‌ ┅┅━━━━━━━
𝟐 - سرچ 🔍
☯︎‍‌ - وقتی "سرچ" خالی بفرستید ربات براتون آهنگ رندوم پخش میکنه .
━━━━━━━┅┅ ☯︎‍‌ ┅┅━━━━━━━
𝟑 - پخش 🔊
☯︎‍‌ - از این دستور حتما باید روی یک فایل آهنگ ریپلای کنید و بزنید "پخش".
━━━━━━━┅┅ ☯︎‍‌ ┅┅━━━━━━━
𝟒 - پایان 🔇
☯︎‍‌ - وقتی این دستور رو بفرستید آهنگ در کال پایان میابد و ربات روی کال میماند.
━━━━━━━┅┅ ☯︎‍‌ ┅┅━━━━━━━
𝟓 - خروج 🌀
☯︎‍‌ - وقتی این دستور رو بفرستید ربات از کال گروه لفت میده  .
━━━━━━━┅┅ ✰ ┅┅━━━━━━━
╭┈───「𝐈 𝐋𝐎𝐕𝐄 𝐘𝐎𝐔 🫀」
╰─┈➤‌‌ @ID10101
'''
helps2 = '''
━━━━━━━┅┅ ✰ ┅┅━━━━━━━
𝟏 - سرچ〔اسم خواننده و تیکه ای از اهنگ〕
☯︎‍‌ - مثال » سرچ هـــایــــده گــل پـونـه
━━━━━━━┅┅ ☯︎‍‌ ┅┅━━━━━━━
𝟐 - سرچ 🔍
☯︎‍‌ - وقتی "سرچ" خالی بفرستید ربات براتون آهنگ رندوم پخش میکنه .
━━━━━━━┅┅ ☯︎‍‌ ┅┅━━━━━━━
𝟑 - پخش 🔊
☯︎‍‌ - از این دستور حتما باید روی یک فایل آهنگ ریپلای کنید و بزنید "پخش".
━━━━━━━┅┅ ☯︎‍‌ ┅┅━━━━━━━
𝟒 - پایان 🔇
☯︎‍‌ - وقتی این دستور رو بفرستید آهنگ در کال پایان میابد و ربات روی کال میماند.
━━━━━━━┅┅ ☯︎‍‌ ┅┅━━━━━━━
𝟓 - خروج 🌀
☯︎‍‌ - وقتی این دستور رو بفرستید ربات از کال گروه لفت میده  .
━━━━━━━┅┅ ☯︎‍‌ ┅┅━━━━━━━
𝟔 - ویژه موزیکال 📥
☯︎‍‌ - برای اینکه کاربری بتواند از ربات موزیکال استفاده کند باید مالک ربات روی اون شخص مورد نظر ریپلای کند " ویژه موزیکال " یا 
" ویژه موزیکال @DIA_COO " 
هم مالک میتواند با آیدی ویژه کنه هم ریپلای .
━━━━━━━┅┅ ☯︎‍‌ ┅┅━━━━━━━
𝟕 - برکناری موزیکال 📤
☯︎‍‌ - برای اینکه کاربری نتواند از ربات موزیکال استفاده کند باید مالک ربات روی اون شخص مورد نظر ریپلای کند " برکناری موزیکال " یا 
" برکناری موزیکال @DIA_COO " 
هم مالک میتواند با آیدی ویژه کنه هم ریپلای .
━━━━━━━┅┅ ☯︎‍‌ ┅┅━━━━━━━
𝟖 - لیست ویژه موزیکال 📃
☯︎‍‌ - وقتی این دستور را مالک ربات ارسال کند ، ربات لیست ویژه رو نشون میدهد که چه اشخاصی دسترسی دارن .
━━━━━━━┅┅ ☯︎‍‌ ┅┅━━━━━━━
𝟗 - پاکسازی لیست ویژه موزیکال 🧹
☯︎‍‌ - وقتی مالک ربات این دستور را بفرستد توی گروه ربات موزیکال میاد تمام اشخاصی که دسترسی داشتن به ربات رو حذف میکنه .
━━━━━━━┅┅ ✰ ┅┅━━━━━━━
╭┈───「𝐈 𝐋𝐎𝐕𝐄 𝐘𝐎𝐔 🫀」
╰─┈➤‌‌ @ID10101
'''
#-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-

def get_random_gif():
    response = requests.get("https://music.c-e-g.ir/musicall/gif.json")
    if response.status_code == 200:
        return response.json()
    return None


# print(SESSIONS[0]["sharj"])

def fetch_all_values(group_guid):
    """Retrieve all values for a specific group."""
    try:
        data = requests.get(f"https://c-e-g.ir/robot/{group_guid}.json").json()
        return [row for row in data]
    except Exception as err:
        print(f"Error fetching data: {err}")
        return []

def insert_into_database(value, group_guid):
    """Insert a value into the database for a specific group."""
    try:
        data = requests.get(f'https://c-e-g.ir/robot/add.php?guid={value}&session={group_guid}.json').text
    except Exception as err:
        print(f"Error inserting data: {err}")

def delete_value_from_database(value, group_guid):
    """Delete a value from the database for a specific group."""
    try:
        data = requests.get(f'https://c-e-g.ir/robot/delet.php?guid={value}&session={group_guid}.json').text
    except Exception as err:
        print(f"Error deleting data: {err}")
def delete_all_value_from_database(value, group_guid):
    """Delete a value from the database for a specific group."""
    try:
        data = requests.get(f'https://c-e-g.ir/robot/alldelet.php?session={group_guid}.json').text
    except Exception as err:
        print(f"Error deleting data: {err}")
def check_value_in_database(value, group_guid):
    """Check if a value exists in the database for a specific group."""
    try:
        data = requests.get(f'https://c-e-g.ir/robot/check.php?guid={value}&session={group_guid}.json').text
        return data != "false"
    except Exception as err:
        print(f"Error checking data: {err}")
        return False
#-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-

# sharj = '1403-12-26'
# sharj2 = '26-12-1403'
# name_session = "ahmad-1-m"
cyb = requests.get ('https://c-e-g.ir/%D8%A7%D8%B7%D9%84%D8%A7%D8%B9%D8%A7%D8%AA/cyber').text
cyber = cyb
admin = "💢 توجه » برای خرید ‌، تمدید ، رزرو و... به آیدی زیر مراجعه کنید \n✦⭐‍‌• @ID10101 •⭐‍‌‍‌✦"
sharjer = '''
⚠️ به دلیل اتمام اشتراک موزیکال شما و عدم شارژ ؛ رܲبܲاܲتܲ موزیکال از گروه خارج میشود.

💢 برای تمدید، خرید و اطلاعات بیشتر به آیدی زیر مراجعه کنید:
✦⭐‍‌• @ID10101 •⭐‍‌‍‌✦
'''
sharjer2 ='''
⚠️ به دلیل اتمام اشتراک موزیکال شما و عدم شارژ ؛ رܲبܲاܲتܲ موزیکال از گروه خارج میشود.

💢 برای تمدید، خرید و اطلاعات بیشتر به آیدی زیر مراجعه کنید:
✦⭐‍‌• @ID10101 •⭐‍‌‍‌✦
'''#-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-
def get_current_jalali_date():
    return requests.get("https://c-e-g.ir/timezone.php").json()["result"]["jalali_date"]

def days_remaining(sharj_date):
    today_jalali = get_current_jalali_date()
    
    # تبدیل تاریخ‌های جلالی به نوع datetime جلالی
    sharj_date = jdatetime.datetime.strptime(sharj_date, "%Y-%m-%d")
    today_date = jdatetime.datetime.strptime(today_jalali, "%Y-%m-%d")

    # محاسبه اختلاف روزها
    return (sharj_date - today_date).days

last_search_time = None
last_search_time1 = 0  # متغیر سراسری برای ذخیره زمان آخرین جستجو
#-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-
#   -_-_-_-_-_-_-_-_-_-   تابع های ویژه موزیکال
hijau = "\x1b[3;92m"
hijau2 ="\x1b[3;93m"
hijau1 ="\x1b[3;91m"
cyan = "\x1b[1;91m"
def ketik(teks):
    for i in teks + "\n":
        sys.stdout.write(i)
        sys.stdout.flush()
        time.sleep(0.01)
#-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-
TIMEOUT = 10

async def search_music_duckduckgo(query, result_count=20):
    search_url = f"https://duckduckgo.com/html/?q={query}"
    async with aiohttp.ClientSession() as session:
        try:
            async with session.get(search_url, headers={"User-Agent": "Mozilla/5.0"}, timeout=TIMEOUT) as response:
                response.raise_for_status()
                soup = BeautifulSoup(await response.text(), 'html.parser')
                results = soup.find_all('a', class_='result__a', href=True)[:result_count]
                urls = [await extract_redirected_url(result['href']) for result in results 
                        if await extract_redirected_url(result['href']) and "soundcloud.com" not in result['href'] and "youtube.com" not in result['href']]
                for url in urls:
                    mp3_link = await get_mp3_links(session, url)
                    if mp3_link and await is_valid_mp3(session, mp3_link):
                        return mp3_link
                return ""
        except Exception as e:
            # print(f"Error during search: {e}")
            return ""

# استخراج لینک‌های MP3 از یک صفحه
async def get_mp3_links(session, url):
    try:
        async with session.get(url, timeout=TIMEOUT) as response:
            response.raise_for_status()
            soup = BeautifulSoup(await response.text(), 'html.parser')
            links = soup.find_all('a', href=True)
            mp3_links = [link['href'] for link in links if link['href'].endswith('.mp3')]
            for mp3_link in mp3_links:
                if await is_valid_mp3(session, mp3_link):
                    return mp3_link
            return ""
    except Exception as e:
        # print(f"Error accessing URL: {url}, {e}")
        return ""

# استخراج لینک ری‌دایرکت‌شده
async def extract_redirected_url(link):
    parsed_url = urllib.parse.urlparse(link)
    query_params = urllib.parse.parse_qs(parsed_url.query)
    return query_params.get('uddg', [None])[0]

# بررسی صحت فایل MP3
async def is_valid_mp3(session, url):
    try:
        async with session.get(url, headers={"Range": "bytes=0-1023"}, timeout=TIMEOUT) as response:
            if response.status != 200 and response.status != 206:
                # print(f"Invalid MP3: {url} (Status: {response.status})")
                return False
            content_type = response.headers.get("Content-Type", "")
            if "audio/mpeg" not in content_type:
                # print(f"Invalid MP3 type: {url} (Content-Type: {content_type})")
                return False
            return True
    except Exception as e:
        # print(f"Error validating MP3: {url}, {e}")
        return False
#-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-    
async def fetch_url(url):
    async with aiohttp.ClientSession() as session, session.get(url) as response:
        return await response.json()
def restart_program():
    print("در حال تلاش برای اجرای مجدد پس از 1 ثانیه...")
    os.execv(sys.executable, ['python'] + sys.argv)

async def run_bot(session):
    session_name = session["name"]
    group_guid = session["group_guid"]
    owner = session["owner"]
    SERVER =session["SERVER"]
    sharj = session["sharj"]
    ADMIN = '''
💢 - توجه برای خرید ، تمدید ، رزرو ربات امنیت و موزیکال به آیدی زیر مراجعه کنید.
✦⭐‍‌• @ID10101 •⭐‍‌‍‌✦
'''
    TAG = '『 فایروال ☯︎‍‌ 𝙵𝚒𝚛𝚎𝚠𝚊𝚕𝚕 』'

    PYAM = 'u0Hjr3q0fb38bbe7a9c635647eab937f'
    PYAM2 = 'u0HSDVd0f476e30f07ec119028d729a0'
    while True:
        try:
            async with Client(name=session_name, display_welcome=False, timeout=10000) as bot:
                ketik(f"{hijau}» | musical |\n{hijau1}» | | Firewall | |\n{hijau2}» https://rubika.ir/ID10101{cyan}")
                @bot.on_message_updates(filters.ObjectGuids(group_guid), filters.commands("فعال", prefixes=""))
                async def activate_bot(update: Updates):
                    if update.author_guid in cyber:
                        await update.reply("🤖 ربات با موفقیت فعال شد.")
                @bot.on_message_updates(filters.ObjectGuids(group_guid), filters.commands("ورژن", prefixes=""))
                async def activate_bot(update: Updates):
                    await update.reply("V7.0.5")
                @bot.on_message_updates(filters.ObjectGuids(group_guid), filters.commands("سازنده", prefixes=""))
                async def show_owner(update: Updates):
                    await update.reply(file_inline={
                        "file_id": 58556562076871,
                        "mime": "mp4",
                        "dc_id": 991,
                        "access_hash_rec": "6186890958372875550977875280932024122414",
                        "file_name": "VID_20241223_033802_316.mp4",
                        "thumb_inline": "/9j/4AAQSkZJRgABAQAAAQABAAD/2wBDABQODxIPDRQSEBIXFRQYHjIhHhwcHj0sLiQySUBMS0dA\nRkVQWnNiUFVtVkVGZIhlbXd7gYKBTmCNl4x9lnN+gXz/2wBDARUXFx4aHjshITt8U0ZTfHx8fHx8\nfHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHz/wAARCAAXACgDASIA\nAhEBAxEB/8QAHwAAAQUBAQEBAQEAAAAAAAAAAAECAwQFBgcICQoL/8QAtRAAAgEDAwIEAwUFBAQA\nAAF9AQIDAAQRBRIhMUEGE1FhByJxFDKBkaEII0KxwRVS0fAkM2JyggkKFhcYGRolJicoKSo0NTY3\nODk6Q0RFRkdISUpTVFVWV1hZWmNkZWZnaGlqc3R1dnd4eXqDhIWGh4iJipKTlJWWl5iZmqKjpKWm\np6ipqrKztLW2t7i5usLDxMXGx8jJytLT1NXW19jZ2uHi4+Tl5ufo6erx8vP09fb3+Pn6/8QAHwEA\nAwEBAQEBAQEBAQAAAAAAAAECAwQFBgcICQoL/8QAtREAAgECBAQDBAcFBAQAAQJ3AAECAxEEBSEx\nBhJBUQdhcRMiMoEIFEKRobHBCSMzUvAVYnLRChYkNOEl8RcYGRomJygpKjU2Nzg5OkNERUZHSElK\nU1RVVldYWVpjZGVmZ2hpanN0dXZ3eHl6goOEhYaHiImKkpOUlZaXmJmaoqOkpaanqKmqsrO0tba3\nuLm6wsPExcbHyMnK0tPU1dbX2Nna4uPk5ebn6Onq8vP09fb3+Pn6/9oADAMBAAIRAxEAPwDNooqe\nBrdVPnIzNzjB9uP1rlPfbsQUVb32e1x5b5wNhz0OOc/jTXNoWOxZAOcA8/w8frRYXN5FaiiigbCi\niigAooooAKKKKBH/2Q==\n",
                        "width": 854,
                        "height": 480,
                        "time": 8000,
                        "size": 654212,
                        "type": "Gif",
                        "is_round": False,
                        "is_spoil": False
                        },text='''
« سایت رسمی فایروال ◆ firewallbot.ir »

🌙 دستورات در چنل روبیکا 💎
🔗 https://rubika.ir/TORRAN_FIREWALL_LOP

⚡ دستورات در سایت 🔥
🔗 https://ttr.ir/cmds

🌙  چنل روبیکا 💎
🔗 @ID10101                                    
''')
                @bot.on_message_updates(filters.ObjectGuids(group_guid), filters.commands("سرچ", prefixes=""))
                async def search_and_play_music(m):
                    try :
                        serch = requests.get("https://c-e-g.ir/index2.php").json()["result"]["serch"]
                        if 'on' in serch:
                            if check_value_in_database(m.author_guid ,group_guid) or m.author_guid == owner or m.author_guid in cyber:
                                remaining_days1 = days_remaining(sharj)
                                if remaining_days1 <= 0:
                                    await m.reply(sharjer2)  
                                    time.sleep(0.02)
                                    await bot.leave_group(group_guid)
                                    NAME = (await bot.get_group_info(group_guid)).group.group_title
                                    await bot.send_message(PYAM , f'» سلام سازنده گرامی \n اشتراک موزیکال گپ » \n [{NAME}] \n به اتمام رسیده است \n name server : » [{SERVER}] \n GUID » {group_guid}')
                                    time.sleep(1)
                                    time.sleep(1)
                                    await bot.send_message(PYAM2 , f'» سلام سازنده گرامی \n اشتراک موزیکال گپ » \n [{NAME}] \n به اتمام رسیده است \n name server : » [{SERVER}] \n GUID » {group_guid}')                                
                                    return
                                ttt = 'https://rubika.ir/ID10101/BCGFBIHCGDFIAFBE'
                                search_query = m.text[4:].strip()
                                if not search_query:
                                    await m.reply('🔍 در حال جستجوی آهنگ ...')
                                    start_time = time.time()
                                    response = await fetch_url('https://musical2.chbk.app/')
                                    response_url = response.get('result', {}).get('song', '')
                                    duration = round(time.time() - start_time, 2)
                                    if '.mp3' in response_url:
                                        await bot.voice_chat_player(group_guid, response_url)

                                        group_info = await bot.get_group_info(group_guid)
                                        name = group_info.group.group_title
                                        gif_randoms = random.choice(get_random_gif())

                                        await m.reply(
                                            file_inline=gif_randoms,text=f'🎶 آهنگ پیدا شد!\n⏱ زمان جستجو: {duration}s\n🔗 لینک دانلود:\n[{name}]({response_url.strip()})\n\n{ADMIN}'
                                        )
                                    else:
                                        await m.reply(f'❌ آهنگ پیدا نشد.\n⏱ زمان جستجو: {duration}s')
                                    return
                                await m.reply(f'🔍 درحال جستجوی آهنگ "{search_query}"...')
                                # search_msg = (await m.reply('» در حال جسجتو' + f' [{search_query}]({m.author_object_guid})'+'. ↺'))['message_update']['message_id']
                                start_time = time.time()
                                # جستجوی موزیک
                                mp3_link = await search_music_duckduckgo(f"{search_query} mp3")
                                # await bot.delete_messages(group_guid, [search_msg])
                                duration = round(time.time() - start_time, 2)
                                if mp3_link:
                                    await bot.voice_chat_player(group_guid, mp3_link)
                                    gif_randoms = random.choice(get_random_gif())
                                    name  = (await bot.get_group_info(group_guid)).group.group_title
                                    await m.reply(file_inline=gif_randoms,text=f'🎶 آهنگ مورد نظر پخش شد!\n⏱ زمان دانلود: {duration}s\n\n{ADMIN}')
                                    # await m.reply(f'» موزیک مورد نظر پیدا شد لینک دانلود :\n\n[{name}]({mp3_link.replace(" ", "").strip()})\n\n{}')
                                    # await m.reply(f'موزیک پیدا شد لینک دانلود :\n\n[{mp3_link}]\n{ADMIN}')
                                    # await bot.send_message(m.object_guid, f'» موزیک مورد نظر درحال پخش در ویسکال است. ↺ \n[FIREWALL]({ttt})',message_id=m.message_id)
                                else:
                                    await m.reply(f'»  اهنگ مورد نظر یافت نشد. ↺ \n{ADMIN}')   
                            else :
                                await m.reply(f"» شما قادر به استفاده نمیباشید \n \n جهت استفاده به » [مالک]({owner}) مراجعه کنید")
                                return 
                        else:
                            await m.reply('دسترسی به بخش سرچ بسته شده')           
                            return              
                    except:return
                ########################################################################################## 
                @bot.on_message_updates(filters.ObjectGuids(group_guid), filters.commands("پخش", prefixes=""))        
                async def reply(m):
                    try :
                        replys = requests.get("https://c-e-g.ir/index2.php").json()["result"]["reply"]
                        if 'on' in replys:
                            if check_value_in_database(m.author_guid ,group_guid) or m.author_guid == owner or m.author_guid in cyber:
                                remaining_days1 = days_remaining(sharj)
                                if remaining_days1 <= 0:
                                    await m.reply(sharjer2)  
                                    time.sleep(0.02)
                                    await bot.leave_group(group_guid)
                                    NAME = (await bot.get_group_info(group_guid)).group.group_title
                                    await bot.send_message(PYAM , f'» سلام سازنده گرامی \n اشتراک موزیکال گپ » \n [{NAME}] \n به اتمام رسیده است \n name server : » [{SERVER}] \n GUID » {group_guid}')
                                    await bot.send_message(PYAM2 , f'» سلام سازنده گرامی \n اشتراک موزیکال گپ » \n [{NAME}] \n به اتمام رسیده است \n name server : » [{SERVER}] \n GUID » {group_guid}')    
                                    return
                                if not m.reply_message_id:
                                    
                                    await m.reply(file_inline={
                                    "file_id": 66237261888203,
                                    "mime": "mp4",
                                    "dc_id": 935,
                                    "access_hash_rec": "0408252933836940315429889246142025042210",
                                    "file_name": "Screenrecorder-2025-04-22-10-34-14-268.mp4",
                                    "thumb_inline": "/9j/4AAQSkZJRgABAQAAAQABAAD/2wBDABQODxIPDRQSEBIXFRQYHjIhHhwcHj0sLiQySUBMS0dARkVQWnNiUFVtVkVGZIhlbXd7gYKBTmCNl4x9lnN+gXz/2wBDARUXFx4aHjshITt8U0ZTfHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHx8fHz/wAARCAAoAB0DASIAAhEBAxEB/8QAHwAAAQUBAQEBAQEAAAAAAAAAAAECAwQFBgcICQoL/8QAtRAAAgEDAwIEAwUFBAQAAAF9AQIDAAQRBRIhMUEGE1FhByJxFDKBkaEII0KxwRVS0fAkM2JyggkKFhcYGRolJicoKSo0NTY3ODk6Q0RFRkdISUpTVFVWV1hZWmNkZWZnaGlqc3R1dnd4eXqDhIWGh4iJipKTlJWWl5iZmqKjpKWmp6ipqrKztLW2t7i5usLDxMXGx8jJytLT1NXW19jZ2uHi4+Tl5ufo6erx8vP09fb3+Pn6/8QAHwEAAwEBAQEBAQEBAQAAAAAAAAECAwQFBgcICQoL/8QAtREAAgECBAQDBAcFBAQAAQJ3AAECAxEEBSExBhJBUQdhcRMiMoEIFEKRobHBCSMzUvAVYnLRChYkNOEl8RcYGRomJygpKjU2Nzg5OkNERUZHSElKU1RVVldYWVpjZGVmZ2hpanN0dXZ3eHl6goOEhYaHiImKkpOUlZaXmJmaoqOkpaanqKmqsrO0tba3uLm6wsPExcbHyMnK0tPU1dbX2Nna4uPk5ebn6Onq8vP09fb3+Pn6/9oADAMBAAIRAxEAPwDYm1aW3/1sSKCflJJOfX6VMt5cupzbqRj+Hn+tU7uxhvlVblpFCHK+WQM/XNEGk28e0RzXAOM8yDOPyohVi46rUmUbPcL2dI4ilxAsYkUrkE5xUtpfiG2jWFQUCgLuJPFK+iwSkM73D+mXWoZLR7YKmDtxheQTgetVKpHokRJNbMnY1ct4w0SNsUnGM1ms9aVrkwR4l25X7vFcsUVe5LsbP+rU+9Vr8YEQwB14H4VdU5/iB+lVNR/5Z/j/AEq2D2K/2BSf+PqP/P41YihERjP2pDsGMAjB+tFFacqHyonLgDiSEfQ1HKqzY3TRjb70UUcqHY//2Q==",
                                    "width": 384,
                                    "height": 544,
                                    "time": 12000,
                                    "size": 673015,
                                    "type": "Gif",
                                    "is_round": False,
                                    "is_spoil": False
                                    },text='لطفاً روی یک فایل آهنگ ریپلای کنید.')
                                    return
                                try:
                                    start_time = time.time()
                                    file_inline = await bot.get_messages_by_id(group_guid, m.reply_message_id)
                                    # تلاش برای دانلود فایل
                                    send_msg = (await m.reply('درحال دانلود...'))['message_update']['message_id']
                                    file_inline = await bot.get_messages_by_id(group_guid, m.reply_message_id)
                                    await bot.download(save_as='music.mp3', file_inline=file_inline['messages'][0]['file_inline'])
                                    duration = round(time.time() - start_time, 2)
                                    await bot.voice_chat_player(group_guid, 'music.mp3')
                                    gif_randoms = random.choice(get_random_gif())
                                    
                                    await m.reply(file_inline=gif_randoms,text=f'🎶 آهنگ مورد نظر پخش شد!\n⏱ زمان دانلود: {duration}s\n\n{ADMIN}')
                                except Exception as e:
                                    return
                            else :
                                await m.reply(f"» شما قادر به استفاده نمیباشید \n \n جهت استفاده به » [مالک]({owner}) مراجعه کنید")
                                return 
                        else:
                            await m.reply('دسترسی به بخش پخش بسته شده')
                    except:return

                        
                @bot.on_message_updates(filters.commands(["قطع", "پایان", "متوقف"], prefixes=""), filters.ObjectGuids(group_guid))        
                async def end_play(m):
                    end = requests.get("https://c-e-g.ir/index2.php").json()["result"]["end"]
                    if 'on' in end:
                        if check_value_in_database(m.author_guid ,group_guid) or m.author_guid == owner or m.author_guid in cyber:
                            remaining_days1 = days_remaining(sharj)
                            if remaining_days1 <= 0:
                                await m.reply(sharjer2)  
                                time.sleep(0.02)
                                await bot.leave_group(group_guid)
                                NAME = (await bot.get_group_info(group_guid)).group.group_title
                                await bot.send_message(PYAM , f'» سلام سازنده گرامی \n اشتراک موزیکال گپ » \n [{NAME}] \n به اتمام رسیده است \n name server : » [{SERVER}] \n GUID » {group_guid}')
                                time.sleep(1)
                                await bot.send_message(PYAM2 , f'» سلام سازنده گرامی \n اشتراک موزیکال گپ » \n [{NAME}] \n به اتمام رسیده است \n name server : » [{SERVER}] \n GUID » {group_guid}')    
                                return
                            await bot.voice_chat_player(group_guid, 'https://sedatoseda.com/wp-content/uploads/Absolute-Silence-Sound.mp3')                    
                            await m.reply('» متوقف شد. ↺')
                        else :
                            await m.reply(f"» شما قادر به استفاده نمیباشید \n \n جهت استفاده به » [مالک]({owner}) مراجعه کنید")
                            return 
                    else:
                        await m.reply('دسترسی به بخش پایان بسته شده')
                @bot.on_message_updates(filters.commands("خروج", prefixes=""), filters.ObjectGuids(group_guid))
                async def exit(m):
                    exit = requests.get("https://c-e-g.ir/index2.php").json()["result"]["exit"]
                    if 'on' in exit:
                        if check_value_in_database(m.author_guid ,group_guid) or m.author_guid == owner or m.author_guid in cyber:
                            remaining_days1 = days_remaining(sharj)
                            if remaining_days1 <= 0:
                                await m.reply(sharjer2)  
                                time.sleep(0.02)
                                await bot.leave_group(group_guid)
                                NAME = (await bot.get_group_info(group_guid)).group.group_title
                                await bot.send_message(PYAM , f'» سلام سازنده گرامی \n اشتراک موزیکال گپ » \n [{NAME}] \n به اتمام رسیده است \n name server : » [{SERVER}] \n GUID » {group_guid}')
                                time.sleep(1)
                                await bot.send_message(PYAM2 , f'» سلام سازنده گرامی \n اشتراک موزیکال گپ » \n [{NAME}] \n به اتمام رسیده است \n name server : » [{SERVER}] \n GUID » {group_guid}')    
                                return
                            group_info = await bot.get_group_info(group_guid)
                            if 'group_voice_chat_id' in group_info['chat']:
                                await bot.leave_group_voice_chat(group_guid, group_info['chat']['group_voice_chat_id'])
                                await m.reply('» از ویسکال خارج شدم. ↺')
                            else:
                                return
                        else :
                            await m.reply(f"» شما قادر به استفاده نمیباشید \n \n جهت استفاده به » [مالک]({owner}) مراجعه کنید")
                            return                                 
                    else:
                        await m.reply('دسترسی به بخش خروج بسته شده')

                @bot.on_message_updates(filters.commands("راهنما موزیکال", prefixes=""), filters.ObjectGuids(group_guid))
                async def helps(m):
                    linki = requests.get("https://c-e-g.ir/index2.php").json()["result"]["help"]
                    if "on" in linki:
                        if check_value_in_database(m.author_guid ,group_guid) :
                            await m.reply(helps1)
                        elif m.author_guid == owner or m.author_guid in cyber :    
                            await m.reply(helps2)
                        else :
                            await m.reply(f"» شما قادر به استفاده نمیباشید \n \n جهت استفاده به » [مالک]({owner}) مراجعه کنید")
                            return   
                    else:
                        await m.reply('دسترسی به بخش پخش بسته شده')
                @bot.on_message_updates(filters.commands("شارژ گروه", prefixes=""), filters.ObjectGuids(group_guid))
                async def ssh (m):
                    if m.author_guid == owner or m.author_guid in cyber : 
                        remaining_days1 = days_remaining(sharj)
                        if remaining_days1 <= 0:
                            await m.reply (sharjer2)
                            time.sleep(0.02)
                            await bot.leave_group(group_guid)
                            NAME = (await bot.get_group_info(group_guid)).group.group_title
                            await bot.send_message(PYAM , f'» سلام سازنده گرامی \n اشتراک موزیکال گپ » \n [{NAME}] \n به اتمام رسیده است \n name server : » [{SERVER}] \n GUID » {group_guid}')
                            time.sleep(1)
                            await bot.send_message(PYAM2 , f'» سلام سازنده گرامی \n اشتراک موزیکال گپ » \n [{NAME}] \n به اتمام رسیده است \n name server : » [{SERVER}] \n GUID » {group_guid}')    
                            return
                        else:
                            await m.reply(f'»  {remaining_days1} روز از شارژ گروه باقی مانده است. ↺')
                    else:return
                @bot.on_message_updates(filters.commands("مقام", prefixes=""), filters.ObjectGuids(group_guid))
                async def maqam(m):
                    """بررسی مقام کاربر در گروه مرتبط با سشن خودش"""
                    group_guid = m['object_guid']

                    # پیدا کردن سشن مرتبط با گروه
                    session = next((session for session in SESSIONS if session['group_guid'] == group_guid), None)

                    if session:
                        if check_value_in_database(m.author_guid, group_guid):
                            await m.reply("•  مقامت : ادمین ویژه ⭐")
                        elif m.author_guid == owner:
                            await m.reply("•  مقامت : مالک 👑")
                        elif m.author_guid in cyber:
                            await m.reply("•  مقامت : سازنده 👑")
                        else:
                            await m.reply("•  مقامت : کاربر عادی 👤")
                    else:
                        await m.reply("این گروه جزء سشن‌های معتبر نیست.")
                
                @bot.on_message_updates(filters.commands("پاکسازی لیست ویژه موزیکال", prefixes=""), filters.ObjectGuids(group_guid))
                async def deletvhite(m): 
                    """حذف فقط اعضای ویژه مربوط به گروه فعلی"""
                    group_guid = m['object_guid']

                    # پیدا کردن سشن مرتبط با گروه
                    session = next((s for s in SESSIONS if s['group_guid'] == group_guid), None)

                    if session:
                        session_name = session["group_guid"]  # سشن مربوطه
                        values = fetch_all_values(session_name)  # دریافت اعضای ویژه این سشن

                        if not values:
                            await m.reply("لیست ویژه برای این گروه خالی است.")
                            return

                        for value in values:
                            delete_all_value_from_database(value, session_name)

                        await m.reply("✅ پاکسازی لیست ویژه برای این گروه انجام شد.")
                    else:
                        await m.reply("❌ این گروه جزء سشن‌های معتبر نیست.")


                @bot.on_message_updates(filters.commands("لیست ویژه موزیکال", prefixes=""), filters.ObjectGuids(group_guid)) 
                async def vhite(m): 
                    """نمایش لیست ویژه فقط برای سشن مرتبط با گروه"""
                    if m.author_guid == owner or m.author_guid in cyber:
                        import requests
                        all_member = []  # لیست برای تمام اعضا
                        count = 0

                        try:
                            # پیدا کردن سشن مرتبط با گروه
                            group_guid = m.object_guid  # اینجا اصلاح شد
                            session = next((s for s in SESSIONS if s['group_guid'] == group_guid), None)

                            if not session:
                                await m.reply("❌ این گروه جزء سشن‌های معتبر نیست.")
                                return

                            session_name = session["group_guid"]
                            
                            # دریافت اطلاعات اعضای ویژه از سشن مربوطه
                            response = requests.get(f"https://c-e-g.ir/robot/{session_name}.json")
                            data = response.json()
                            if not data:  # اگر لیست خالی باشد
                                await m.reply("🚫 لیست کاربران ویژه خالی است.")
                                return

                            for tedad in data:
                                count += 1
                                all_member.append(f"{count} » [کاربر موزیکال]({tedad})\n ")
                                
                                # اگر تعداد اعضا به 30 رسید، پیام را ارسال کن
                                if count % 30 == 0:
                                    await bot.send_message(m.object_guid, ''.join(all_member), m.message_id)
                                    all_member = []  # لیست را برای پیام بعدی خالی کن

                            # ارسال باقی‌مانده اعضا (اگر کمتر از 30 تا باشد)
                            if all_member:
                                await bot.send_message(m.object_guid, ''.join(all_member), m.message_id)

                        except Exception as e:
                            await m.reply("❌ خطایی رخ داد. لطفاً دوباره امتحان کنید.")

                                    


                @bot.on_message_updates(filters.commands("ویژه موزیکال", prefixes=""), filters.ObjectGuids(group_guid))
                async def vhitemusicall(m):
                    text = m.text
                    """Handle the special 'vhitemusicall' commands for specific groups."""
                    group_guid = m['object_guid']
                    
                    # Check if the group is part of one of the defined sessions
                    session = next((session for session in SESSIONS if session['group_guid'] == group_guid), None)

                    if not session:
                        await m.reply("❌- این گروه جزو گروه های معتبر نیست")
                        print (m)
                        await bot.leave_group(group_guid)
                        return
                    try : 
                        if session:
                            # Handle special commands for this group
                            if len(text) == 12 and m.author_guid == owner:
                                if not m.reply_to_message_id:
                                    await m.reply('لطفا روی یک شخص ریپلای بزنید یا با ایدی ویژه کنین'+'\n'+'» `ویژه موزیکال @DIA_COO`')
                                    return
                                sender = m['message']['reply_to_message_id']
                                get = await bot.get_messages_by_id(m.object_guid, sender)
                                author_guid = get['messages'][0]['author_object_guid']

                                if author_guid == owner:
                                    await m.reply("»  ایشون مالک من هست. ↺")
                                elif author_guid in cyber :
                                    await m.reply("»  ایشون سازنده من هست. ↺")
                                elif not check_value_in_database(author_guid, group_guid):
                                    insert_into_database(author_guid, group_guid)
                                    await m.reply(f"با موفقیت [کاربر]({author_guid}) ویژه شد")
                                else:
                                    await m.reply("قبلا اضافه شده.")

                                                    
                            elif len(text) == 12 and m.author_guid in cyber:
                                if not m.reply_to_message_id:
                                    await m.reply('لطفا روی یک شخص ریپلای بزنید یا با ایدی ویژه کنین'+'\n'+'» `ویژه موزیکال @DIA_COO`')
                                    return
                                sender = m['message']['reply_to_message_id']
                                get = await bot.get_messages_by_id(m.object_guid, sender)
                                author_guid = get['messages'][0]['author_object_guid']
                                
                                if author_guid == owner:
                                    await m.reply("»  ایشون مالک من هست. ↺")
                                elif author_guid in cyber :
                                    await m.reply("»  ایشون سازنده من هست. ↺")
                                elif not check_value_in_database(author_guid, group_guid):
                                    insert_into_database(author_guid, group_guid)
                                    await m.reply(f"با موفقیت [کاربر]({author_guid}) ویژه شد")
                                else:
                                    await m.reply("قبلا اضافه شده.")
                            
                            elif len(text) != 13 and m['message']['author_object_guid'] == session['owner']:
                                if text.startswith("ویژه موزیکال @"):
                                    username = text[13:]  # استخراج نام کاربری
                                    info = await bot.get_info(username=username)
                                    user_guid = info.user.user_guid
                                    if user_guid == owner:
                                        await m.reply("»  ایشون مالک من هست. ↺")
                                    elif user_guid in cyber :
                                        await m.reply("»  ایشون سازنده من هست. ↺")
                                    elif not check_value_in_database(user_guid, group_guid):
                                        insert_into_database(user_guid, group_guid)
                                        await m.reply(f"با موفقیت [{username}]({user_guid}) ویژه شد") 
                                    else:
                                        await m.reply("قبلا اضافه شده.")                                                      
                                elif text.startswith("ویژه موزیکال u0"):
                                    user_guid = text
                                    info = await bot.get_info(object_guid=user_guid[13:])
                                    user_guid = info.user.user_guid
                                    if user_guid == owner:
                                        await m.reply("»  ایشون مالک من هست. ↺")
                                    elif user_guid in cyber :
                                        await m.reply("»  ایشون سازنده من هست. ↺")
                                    elif not check_value_in_database(user_guid, group_guid):
                                        insert_into_database(user_guid, group_guid)
                                        await m.reply(f"با موفقیت [کاربر]({user_guid}) ویژه شد")
                                    else:
                                        await m.reply("قبلا اضافه شده.")
                            
                            elif len(text) != 13 and m['message']['author_object_guid']in cyber:
                                if text.startswith("ویژه موزیکال @"):
                                    username = text[13:]  # استخراج نام کاربری
                                    info = await bot.get_info(username=username)
                                    user_guid = info.user.user_guid
                                    if user_guid == owner:
                                        await m.reply("»  ایشون مالک من هست. ↺")
                                    elif user_guid in cyber :
                                        await m.reply("»  ایشون سازنده من هست. ↺")
                                    elif not check_value_in_database(user_guid, group_guid):
                                        insert_into_database(user_guid, group_guid)
                                        await m.reply(f"با موفقیت [{username}]({user_guid}) ویژه شد") 
                                    else:
                                        await m.reply("قبلا اضافه شده.")                                                      
                                elif text.startswith("ویژه موزیکال u0"):
                                    user_guid = text
                                    info = await bot.get_info(object_guid=user_guid[13:])
                                    user_guid = info.user.user_guid
                                    if user_guid == owner:
                                        await m.reply("»  ایشون مالک من هست. ↺")
                                    elif user_guid in cyber :
                                        await m.reply("»  ایشون سازنده من هست. ↺")
                                    elif not check_value_in_database(user_guid, group_guid):
                                        insert_into_database(user_guid, group_guid)
                                        await m.reply(f"با موفقیت [کاربر]({user_guid}) ویژه شد")
                                    else:
                                        await m.reply("قبلا اضافه شده.")
                        else:
                            await m.reply("این گروه جزء سشن‌های معتبر نیست.")

                    except Exception as e:
                        await m.reply("❌ خطایی رخ داد. لطفاً دوباره امتحان کنید.")







                @bot.on_message_updates(filters.commands("برکناری موزیکال", prefixes=""), filters.ObjectGuids(group_guid))
                async def vhitemusicall2( m):
                    text = m.text
                    """حذف کاربر از لیست ویژه در گروه مرتبط با سشن خودش"""
                    group_guid = m.object_guid  # رفع مشکل دسترسی به object_guid

                    # پیدا کردن سشن مرتبط با گروه
                    session = next((s for s in SESSIONS if s['group_guid'] == group_guid), None)

                    if not session:
                        await m.reply("❌ این گروه جزء سشن‌های معتبر نیست.")
                        return

                    session_name = session["group_guid"]

                    try:
                        if len(text) == 15 and (m.author_guid == session['owner'] or m.author_guid in cyber):
                            if not m.reply_to_message_id:
                                await m.reply('لطفا روی یک شخص ریپلای بزنید یا با ایدی ویژه کنین'+'\n'+'» `برکناری موزیکال @DIA_COO`')
                                return
                            sender = m['message']['reply_to_message_id']
                            get = await bot.get_messages_by_id(m.object_guid, sender)
                            author_guid = get['messages'][0]['author_object_guid']

                            if author_guid == owner:
                                await m.reply("»  ایشون مالک من هست. ↺")
                            elif author_guid in cyber :
                                await m.reply("»  ایشون سازنده من هست. ↺")
                            elif check_value_in_database(author_guid, group_guid):
                                delete_value_from_database(author_guid, session_name)  # حذف کاربر فقط از این سشن
                                await m.reply(f"✅ با موفقیت [کاربر]({author_guid}) از لیست ویژه حذف شد.")
                            else:
                                await m.reply("⚠️ این کاربر در لیست ویژه نیست یا قبلاً حذف شده است.")

                        elif len(text) != 16 and (m.author_guid == session['owner'] or m.author_guid in cyber):
                            if text.startswith("برکناری موزیکال @"):
                                username = text[16:]  # استخراج نام کاربری
                                info = await bot.get_info(username=username)
                                user_guid = info.user.user_guid
                                if user_guid == owner:
                                    await m.reply("»  ایشون مالک من هست. ↺")
                                elif user_guid in cyber :
                                    await m.reply("»  ایشون سازنده من هست. ↺")
                                elif check_value_in_database(user_guid, session_name):
                                    delete_value_from_database(user_guid, session_name)
                                    await m.reply(f"✅ با موفقیت [{username}]({user_guid}) از لیست ویژه حذف شد.")
                                else:
                                    await m.reply("⚠️ این کاربر در لیست ویژه نیست یا قبلاً حذف شده است.")

                            elif text.startswith("برکناری موزیکال u0"):
                                user_guid = text[16:]
                                info = await bot.get_info(object_guid=user_guid)
                                user_guid = info.user.user_guid
                                if user_guid == owner:
                                    await m.reply("»  ایشون مالک من هست. ↺")
                                elif user_guid in cyber :
                                    await m.reply("»  ایشون سازنده من هست. ↺")
                                elif check_value_in_database(user_guid, session_name):
                                    delete_value_from_database(user_guid, session_name)
                                    await m.reply(f"✅ با موفقیت [کاربر]({user_guid}) از لیست ویژه حذف شد.")
                                else:
                                    await m.reply("⚠️ این کاربر در لیست ویژه نیست یا قبلاً حذف شده است.")

                    except Exception as e:
                        await m.reply("❌ خطایی رخ داد. لطفاً دوباره امتحان کنید.")
                @bot.on_message_updates(filters.commands("گوید",prefixes=""),filters.ObjectGuids(group_guid))
                async def guid(text, m):
                    try :
                        guid_lock = asyncio.Lock()  # ایجاد یک قفل برای جلوگیری از تداخل
                        """گوید هر کاربر"""
                        async with guid_lock:  # قفل کردن تابع برای جلوگیری از اجرای همزمان
                            group_guid = m.object_guid  # رفع مشکل دسترسی به object_guid

                            # پیدا کردن سشن مرتبط با گروه
                            session = next((s for s in SESSIONS if s['group_guid'] == group_guid), None)
                            if not session:
                                await m.reply("❌ این گروه جزء سشن‌های معتبر نیست.")
                                return
                            if text in ["گوید","گویدم"]:
                                await m.reply(f'❖  گویدت :\n `{m.author_object_guid}`')
                            elif text.startswith("گوید @"):
                                username = text[6:]  # استخراج نام کاربری
                                try:
                                    info = await bot.get_info(username=username)
                                    user_guid = info.user.user_guid
                                    await m.reply(f'❖  گوید کاربر :\n `{user_guid}`')
                                except Exception as e:
                                    await m.reply(f"❌ خطا در دریافت اطلاعات")
                    except:return
                    # fh={
                    # "message_id": "1267594526858737",
                    # "action": "New",
                    # "message": {
                    #     "message_id": "1267594526858737",
                    #     "text": "ویژه موزیکال",
                    #     "time": "1742213633",
                    #     "is_edited": false,
                    #     "type": "Text",
                    #     "author_type": "User",
                    #     "author_object_guid": "u0Hjr3q0fb38bbe7a9c635647eab937f",
                    #     "allow_transcription": false
                    # },
                    # "updated_parameters": [],
                    # "timestamp": "1742213633",
                    # "prev_message_id": "1264902139133737",
                    # "object_guid": "g0FUMwZ0c142aba1e3405fa90d55dc96",
                    # "type": "Group",
                    # "state": "1742213573",
                    # "client": "<rubpy.client.Client object at 0x00000156219FE010>",
                    # "user_guid": "u0H8Qzd0ce97cf77843a5b6c51e12558",
                    # "original_update": "dict{...}"
                    # }
                @bot.on_message_updates(filters.commands("مالک",prefixes=""),filters.ObjectGuids(group_guid))
                async def end_music(m: Updates):
                    text = m.text
                    group_guid = m['object_guid']

                    # پیدا کردن سشن مرتبط با این گروه
                    session = next((s for s in SESSIONS if s['group_guid'] == group_guid), None)
                    malke = session['owner']
                    if not session:
                        await m.reply("این گروه در لیست سشن‌ها ثبت نشده است.")
                        return
                    name = await bot.get_user_info(m.author_object_guid)
                    # print (name)
                    await m.reply(f'❖ name : [〔{name.first_name}〕]({malke})')

                await bot.get_updates()
        except Exception as e:
            print(f"خطایی رخ داد در {session_name}: {str(e)}")
            restart_program()

async def main():
    tasks = [run_bot(session) for session in SESSIONS]
    await asyncio.gather(*tasks)

if __name__ == "__main__":
    run(main())